/*-----------------------------------------------------------------------------------------
 *  This software is in the public domain, furnished "as is", without technical
 *  support, and with no warranty, express or implied, as to its usefulness for
 *  any purpose.
 *
 *  RCReceiver.ino:
 *
 *  ESP32 microcontroller software project to implement collection and validation of 
 *  RC PWM pulse lenght data with the ESP-IDF 5.x development invirement.
 *
 *  This is the main control loop to trigger and coordinate the below listed functions on both
 *  cores of the ESP32.
 *
 *  - PwmReceive.ino: reading PWM signals from RC receiver and signal quality checks.
 *    Configurable number of RC signals are read and processed.
 *    The rmt functions are newly implemented to support the ESP32 IDF 3.x architecture.
 *    PWM receiver state maschine is also migrated to this ino.
 *
 *  - MultiSwitch.ino: input functions of a 4 times multiswitch decoder to trigger switching on and off
 *    functions. Hardware design of encoder was taken from www.rc-bastelbu.de YaMS implementation of
 *    Dirk Wiedemann
 *
 *  - Core0.ino: task definition for second ESP32 core (no function running for now)
 *
 *  Author: Volker Frauenstein
 *  Date: 04/01/2026 Version: 1.3 minor bugfixing and adding of an averaging function to the RC_... output 
 *                                interfaces in the PwmReceive.ino

 *  Date: 07/07/2025 Version: 1.2 minor bugfixing and configuration change during review in 
 *                                Multiswitch.ino and PwmReceive.ino
 *  Date: 07/07/2025 Version: 1.1 new runtime reseve calculation implemented in PwmReceive.ino
 *  Date: 02/05/2025 Version: 1.0 migration of Multiswitch functions, new global RC_xxx and MS_xxx definitions added
 *  Date: 10/05/2025 Version: 0.2 RC pwm receiver state machine moved to pwmreceive.ino, core0 task activated
 *  Date: 03/05/2025 Version: 0.1 migration of PwmReceive (replace for RCPwmRead) due to support of new ESP-IDF v5.x
 */

#include "RCReceiver.h"

// generig definitions for debug
//#define DEBUG_C0 1                                              // set activ if timeing debuging core0 is needed

void setup() {                                                  // setup functions at boot

  Serial.begin(115200);                                         // open serial monitor for debug data
  setup_PwmChannels();                                          // set up RC pwm tranceiver functions
  setup_MultiSwitch();                                          // define multiswitch pinout
  setup_Core0();                                                // create task for core0
  Serial.println("Setup of RCReceiver 1.3 done");
}                                                               // end function setup

void loop() {                                                   // main loop on core1

  if (runPwmReciever()) {                                       // collect rc pwm values
    // we have valid pwm data received
    run_MultiSwitch();                                          // check state of Multiswitch on channel 2 and switch if nedded
  }
  else {                                                        // pwm data is invalid
    // call all failsafe functions
    close_MultiSwitch();                                        // for Multiswitch
  }
}                                                               // main loop core1 closed

void TaskCore0(void *pvParameters) {                            // main task on core0

  delay(10);                                                    // give functions time for start up

  #ifdef DEBUG_C0
    Serial.print("TaskCore0 running on core: ");
    Serial.println(xPortGetCoreID());
  #endif

  for (;;) {                                                    // loop forever

    vTaskDelay(1);                                              // short delay to satisfy watchdog
  }
}                                                               // main loop core0 closed

